<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-image: url('http://7system.com.br/img/cloud2.jpg');
            background-size: cover;
            color: black;
            margin: 0;
            padding: 20px;
            text-align: center;
        }

        h1 {
            margin-bottom: 20px;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;
            color: black;
        }

        table, th, td {
            border: 1px solid #ddd;
        }

        th, td {
            padding: 10px;
            text-align: center;
            font-weight: bold
        }

        th {
            background-color: #0cb2d7;
            color: white;
        }

        tr:nth-child(even) {

        }
    </style>
    <title>Média da coxexão - Rack Sala CPD</title>
</head>
<body>

<h1>Média da coxexão - Rack Sala CPD</h1>

<?php

$servername = "149.56.34.221";
$username = "cegosa24h";
$password = "hospital@1234!";
$database = "cegosa24h";

// Criar a conexão
$conn = new mysqli($servername, $username, $password, $database);

// Verificar a conexão
if ($conn->connect_error) {
    // Erro na conexão
    echo '<span style="color: red;">Erro na conexão: ' . $conn->connect_error . '</span>';
} else {
    // Sucesso na conexão
    echo '<span style="color: blue;">Conexão estabelecida com sucesso!</span><br>';

    // Executar SELECT na tabela speedtest_sala19
    $sql = "SELECT h.hostname, scob.ip, max(scob.timestamp) as timestamp, round(avg(scob.dl),0) as dl, round(avg(scob.ul),0) as ul, round(avg(scob.ping),0) as ping, round(avg(scob.jitter),0) as jitter
            FROM hosts as h, speedtest_cpd as scob 
            WHERE h.ip = scob.ip
            GROUP BY h.hostname 
            ORDER BY h.hostname ASC, scob.timestamp DESC";
    $result = $conn->query($sql);

    // Verificar se há resultados
    if ($result->num_rows > 0) {
        // Exibir os registros em verde
        echo '<span style="color: green;">Registros encontrados:</span><br>';

        // Exibir os registros
        echo "<table>";
        echo "<tr>";
        echo "<th>HOSTNAME/IP</th><th>IP</th><th>DATETIME</th><th>DOWNLOAD</th><th>UPLOAD</th><th>PING</th><th>JITTER</th>";
        echo "</tr>";

        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $row["hostname"] . "</td><td>" . $row["ip"] . "</td><td>" . $row["timestamp"] . "</td><td>" . $row["dl"] . "</td><td>" . $row["ul"] . "</td><td>" . $row["ping"] . "</td><td>" . $row["jitter"] . "</td>";
            echo "</tr>";
        }

        echo "</table>";
    } else {
        // Caso não haja registros
        echo '<span style="color: orange;">Nenhum registro encontrado.</span>';
    }

    // Fechar a conexão
    $conn->close();
}
?>
</body>
</html>

