<?php
/**
 * @author Andreas Fischer <bantu@owncloud.com>
 * @author Felix Moeller <mail@felixmoeller.de>
 * @author Frank Karlitschek <frank@karlitschek.de>
 * @author Jakob Sack <mail@jakobsack.de>
 * @author Morris Jobke <hey@morrisjobke.de>
 * @author Robin Appelman <icewind@owncloud.com>
 * @author Roeland Jago Douma <rullzer@owncloud.com>
 * @author Vincent Petry <pvince81@owncloud.com>
 *
 * @copyright Copyright (c) 2018, ownCloud GmbH
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */

// Check if we are a user
OCP\User::checkLoggedIn();

$filename = $_GET["file"];

if (!\OC\Files\Filesystem::file_exists($filename)) {
	\http_response_code(404);
	$tmpl = new OCP\Template('', '404', 'guest');
	$tmpl->assign('file', $filename);
	$tmpl->printPage();
	exit;
}

//Dispatch an event to see if any apps have problem with download
$event = new \Symfony\Component\EventDispatcher\GenericEvent(null, ['path' => $filename]);
OC::$server->getEventDispatcher()->dispatch($event, 'file.beforeGetDirect');
if ($event->hasArgument('errorMessage')) {
	\http_response_code(403);
	$tmpl = new OCP\Template('', '403', 'guest');
	$tmpl->assign('file', $filename);
	$tmpl->printPage();
	exit;
}

$ftype=\OC::$server->getMimeTypeDetector()->getSecureMimeType(\OC\Files\Filesystem::getMimeType($filename));

\header('Content-Type:'.$ftype);
OCP\Response::setContentDispositionHeader(\basename($filename), 'attachment');
OCP\Response::disableCaching();
OCP\Response::setContentLengthHeader(\OC\Files\Filesystem::filesize($filename));

OC_Util::obEnd();
\OC\Files\Filesystem::readfile($filename);
